<?php
// admin/produtos.php - GERENCIADOR DE PRODUTOS E CATEGORIAS

// --- 1. CONEXÃO E LÓGICA ---
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// --- PROCESSAR AÇÕES (SALVAR, EDITAR, EXCLUIR) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // 1. NOVA CATEGORIA
    if (isset($_POST['acao']) && $_POST['acao'] == 'nova_categoria') {
        $stmt = $pdo->prepare("INSERT INTO categorias (nome) VALUES (?)");
        $stmt->execute([$_POST['nome']]);
        header("Location: produtos.php"); exit;
    }

    // 2. EXCLUIR CATEGORIA
    if (isset($_POST['acao']) && $_POST['acao'] == 'excluir_categoria') {
        // Primeiro apaga os produtos da categoria para não dar erro
        $pdo->prepare("DELETE FROM produtos WHERE categoria_id = ?")->execute([$_POST['id']]);
        $pdo->prepare("DELETE FROM categorias WHERE id = ?")->execute([$_POST['id']]);
        header("Location: produtos.php"); exit;
    }

    // 3. NOVO PRODUTO
    if (isset($_POST['acao']) && $_POST['acao'] == 'novo_produto') {
        $sql = "INSERT INTO produtos (categoria_id, nome, descricao, preco, unidade, disponivel) VALUES (:cat, :nome, :desc, :preco, :un, 1)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':cat' => $_POST['categoria_id'],
            ':nome' => $_POST['nome'],
            ':desc' => $_POST['descricao'],
            ':preco' => str_replace(',', '.', $_POST['preco']), // Aceita vírgula
            ':un' => $_POST['unidade']
        ]);
        header("Location: produtos.php"); exit;
    }

    // 4. EDITAR PRODUTO
    if (isset($_POST['acao']) && $_POST['acao'] == 'editar_produto') {
        $sql = "UPDATE produtos SET nome=:nome, descricao=:desc, preco=:preco, unidade=:un WHERE id=:id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':nome' => $_POST['nome'],
            ':desc' => $_POST['descricao'],
            ':preco' => str_replace(',', '.', $_POST['preco']),
            ':un' => $_POST['unidade'],
            ':id' => $_POST['id']
        ]);
        header("Location: produtos.php"); exit;
    }

    // 5. EXCLUIR PRODUTO
    if (isset($_POST['acao']) && $_POST['acao'] == 'excluir_produto') {
        $pdo->prepare("DELETE FROM produtos WHERE id = ?")->execute([$_POST['id']]);
        header("Location: produtos.php"); exit;
    }
}

// --- BUSCAR DADOS ---
$categorias = $pdo->query("SELECT * FROM categorias ORDER BY nome ASC")->fetchAll(PDO::FETCH_ASSOC);

// Busca produtos agrupados
$listaProdutos = [];
foreach($categorias as $cat) {
    $stmt = $pdo->prepare("SELECT * FROM produtos WHERE categoria_id = ? ORDER BY nome ASC");
    $stmt->execute([$cat['id']]);
    $listaProdutos[$cat['id']] = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Produtos</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #eaeff2; margin: 0; padding: 20px; }
        
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .btn-voltar { text-decoration: none; color: #555; font-weight: bold; }
        
        .card { background: white; border-radius: 8px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        
        h2, h3 { margin-top: 0; color: #2c3e50; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; color: #777; font-size: 0.9rem; }
        
        .btn { padding: 8px 12px; border: none; border-radius: 5px; cursor: pointer; color: white; font-size: 0.9rem; text-decoration: none; display: inline-block;}
        .btn-green { background: #27ae60; }
        .btn-blue { background: #3498db; }
        .btn-red { background: #e74c3c; }
        .btn-orange { background: #e67e22; }

        .acoes { display: flex; gap: 5px; }

        /* MODAL */
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); align-items: center; justify-content: center; z-index: 100; }
        .modal-content { background: white; padding: 25px; border-radius: 10px; width: 100%; max-width: 400px; box-shadow: 0 5px 15px rgba(0,0,0,0.2); }
        
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; color: #555; }
        .form-control { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box; }
        
        .header-cat { display: flex; justify-content: space-between; align-items: center; background: #2c3e50; color: white; padding: 10px; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body>

    <div class="header">
        <a href="index.php" class="btn-voltar"><i class="fas fa-arrow-left"></i> Voltar ao Painel</a>
        <h1><i class="fas fa-boxes"></i> Produtos e Categorias</h1>
    </div>

    <div style="margin-bottom: 20px; display: flex; gap: 10px;">
        <button onclick="abrirModal('modal-cat')" class="btn btn-blue"><i class="fas fa-folder-plus"></i> Nova Categoria</button>
        <button onclick="abrirModal('modal-prod')" class="btn btn-green"><i class="fas fa-plus-circle"></i> Novo Produto</button>
    </div>

    <?php foreach($categorias as $cat): ?>
        <div class="header-cat">
            <span><?php echo $cat['nome']; ?></span>
            <form method="POST" onsubmit="return confirm('Tem certeza? Isso apagará todos os produtos desta categoria!');" style="margin:0;">
                <input type="hidden" name="acao" value="excluir_categoria">
                <input type="hidden" name="id" value="<?php echo $cat['id']; ?>">
                <button class="btn btn-red" style="padding: 5px 10px; font-size: 0.8rem;"><i class="fas fa-trash"></i></button>
            </form>
        </div>

        <div class="card" style="padding:0; overflow:hidden;">
            <?php if(count($listaProdutos[$cat['id']]) == 0): ?>
                <div style="padding:20px; text-align:center; color:#999;">Nenhum produto nesta categoria.</div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Preço</th>
                            <th>Unidade</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($listaProdutos[$cat['id']] as $prod): ?>
                        <tr>
                            <td>
                                <strong><?php echo $prod['nome']; ?></strong><br>
                                <small style="color:#888"><?php echo $prod['descricao']; ?></small>
                            </td>
                            <td>R$ <?php echo number_format($prod['preco'], 2, ',', '.'); ?></td>
                            <td><span style="background:#eee; padding:2px 6px; border-radius:4px; font-size:0.8rem;"><?php echo $prod['unidade']; ?></span></td>
                            <td class="acoes">
                                <button onclick="editarProduto(<?php echo htmlspecialchars(json_encode($prod)); ?>)" class="btn btn-orange"><i class="fas fa-edit"></i></button>
                                
                                <form method="POST" onsubmit="return confirm('Excluir este produto?');">
                                    <input type="hidden" name="acao" value="excluir_produto">
                                    <input type="hidden" name="id" value="<?php echo $prod['id']; ?>">
                                    <button class="btn btn-red"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>

    <div id="modal-cat" class="modal">
        <div class="modal-content">
            <h3>Nova Categoria</h3>
            <form method="POST">
                <input type="hidden" name="acao" value="nova_categoria">
                <div class="form-group">
                    <label>Nome da Categoria</label>
                    <input type="text" name="nome" class="form-control" placeholder="Ex: Bebidas, Lanches..." required>
                </div>
                <button type="submit" class="btn btn-green" style="width:100%">Salvar</button>
                <button type="button" onclick="fecharModal('modal-cat')" class="btn btn-red" style="width:100%; margin-top:5px; background:#ccc; color:#333;">Cancelar</button>
            </form>
        </div>
    </div>

    <div id="modal-prod" class="modal">
        <div class="modal-content">
            <h3 id="titulo-modal-prod">Novo Produto</h3>
            <form method="POST">
                <input type="hidden" name="acao" id="acao-prod" value="novo_produto">
                <input type="hidden" name="id" id="id-prod">
                
                <div class="form-group">
                    <label>Categoria</label>
                    <select name="categoria_id" id="cat-prod" class="form-control" required>
                        <?php foreach($categorias as $c): ?>
                            <option value="<?php echo $c['id']; ?>"><?php echo $c['nome']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label>Nome do Produto</label>
                    <input type="text" name="nome" id="nome-prod" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>Descrição (Ingredientes)</label>
                    <input type="text" name="descricao" id="desc-prod" class="form-control">
                </div>

                <div style="display:flex; gap:10px;">
                    <div class="form-group" style="flex:1">
                        <label>Preço (R$)</label>
                        <input type="text" name="preco" id="preco-prod" class="form-control" placeholder="0,00" required>
                    </div>
                    <div class="form-group" style="width:100px;">
                        <label>Unidade</label>
                        <select name="unidade" id="un-prod" class="form-control">
                            <option value="UN">UN</option>
                            <option value="KG">KG</option>
                        </select>
                    </div>
                </div>

                <button type="submit" class="btn btn-green" style="width:100%">Salvar Produto</button>
                <button type="button" onclick="fecharModal('modal-prod')" class="btn btn-red" style="width:100%; margin-top:5px; background:#ccc; color:#333;">Cancelar</button>
            </form>
        </div>
    </div>

    <script>
        function abrirModal(id) {
            document.getElementById(id).style.display = 'flex';
            
            // Limpa form se for novo produto
            if(id === 'modal-prod') {
                document.getElementById('titulo-modal-prod').innerText = "Novo Produto";
                document.getElementById('acao-prod').value = "novo_produto";
                document.getElementById('nome-prod').value = "";
                document.getElementById('desc-prod').value = "";
                document.getElementById('preco-prod').value = "";
            }
        }

        function fecharModal(id) {
            document.getElementById(id).style.display = 'none';
        }

        function editarProduto(prod) {
            abrirModal('modal-prod');
            document.getElementById('titulo-modal-prod').innerText = "Editar Produto";
            document.getElementById('acao-prod').value = "editar_produto";
            
            document.getElementById('id-prod').value = prod.id;
            document.getElementById('cat-prod').value = prod.categoria_id;
            document.getElementById('nome-prod').value = prod.nome;
            document.getElementById('desc-prod').value = prod.descricao;
            document.getElementById('preco-prod').value = prod.preco.replace('.', ',');
            document.getElementById('un-prod').value = prod.unidade;
        }

        // Fechar ao clicar fora
        window.onclick = function(event) {
            if (event.target.className === 'modal') {
                event.target.style.display = "none";
            }
        }
    </script>
</body>
</html>