<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerir Categorias</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #eaeff2; padding: 20px; }
        
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .btn-voltar { text-decoration: none; color: #555; font-weight: bold; }
        .btn-novo { background: #8e44ad; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-weight: bold; }
        
        .card { background: white; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); overflow: hidden; max-width: 800px; margin: 0 auto; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 15px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; color: #555; }
        
        .btn-icon { border: none; background: none; cursor: pointer; font-size: 1.1rem; margin-right: 10px; }
        .text-blue { color: #3498db; }
        .text-red { color: #e74c3c; }

        /* MODAL */
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); justify-content: center; align-items: center; }
        .modal-content { background: white; padding: 25px; border-radius: 10px; width: 400px; }
        
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; color: #666; }
        .form-control { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; box-sizing: border-box; }
        
        .modal-footer { display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px; }
        .btn-cancel { background: #ccc; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; }
        .btn-save { background: #8e44ad; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; }
    </style>
</head>
<body>

    <div class="header">
        <a href="produtos.php" class="btn-voltar"><i class="fas fa-arrow-left"></i> Voltar para Produtos</a>
        <h2>Categorias do Cardápio</h2>
        <button class="btn-novo" onclick="abrirModal()">+ Nova Categoria</button>
    </div>

    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nome da Categoria</th>
                    <th>Ícone (Opcional)</th>
                    <th style="text-align:right">Ações</th>
                </tr>
            </thead>
            <tbody id="lista-categorias">
                </tbody>
        </table>
    </div>

    <div class="modal" id="modal-cat">
        <div class="modal-content">
            <h3 id="modal-titulo">Nova Categoria</h3>
            <input type="hidden" id="cat-id">
            
            <div class="form-group">
                <label>Nome</label>
                <input type="text" id="cat-nome" class="form-control" placeholder="Ex: Bebidas">
            </div>

            <div class="form-group">
                <label>Ícone (Nome do arquivo ou classe FontAwesome)</label>
                <input type="text" id="cat-icone" class="form-control" placeholder="Ex: icon-drink.png ou fas fa-beer">
                <small style="color:#999">Para imagens locais, coloque na pasta /imagens</small>
            </div>

            <div class="modal-footer">
                <button class="btn-cancel" onclick="fecharModal()">Cancelar</button>
                <button class="btn-save" onclick="salvarCategoria()">Salvar</button>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", carregarCategorias);

        function carregarCategorias() {
            fetch('../api/get_categorias.php')
                .then(res => res.json())
                .then(cats => {
                    const tbody = document.getElementById('lista-categorias');
                    tbody.innerHTML = '';
                    
                    if(cats.length === 0) {
                        tbody.innerHTML = '<tr><td colspan="4" style="text-align:center">Nenhuma categoria cadastrada.</td></tr>';
                        return;
                    }

                    cats.forEach(c => {
                        // Prepara dados para edição
                        let dadosJSON = JSON.stringify(c).replace(/"/g, "&quot;");

                        let tr = `
                            <tr>
                                <td>${c.id}</td>
                                <td><strong>${c.nome}</strong></td>
                                <td>${c.icone || '-'}</td>
                                <td style="text-align:right">
                                    <button class="btn-icon text-blue" onclick="editarCategoria(${dadosJSON})">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn-icon text-red" onclick="excluirCategoria(${c.id}, '${c.nome}')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        `;
                        tbody.innerHTML += tr;
                    });
                });
        }

        function abrirModal() {
            document.getElementById('modal-titulo').innerText = "Nova Categoria";
            document.getElementById('cat-id').value = "";
            document.getElementById('cat-nome').value = "";
            document.getElementById('cat-icone').value = "";
            document.getElementById('modal-cat').style.display = 'flex';
        }

        function editarCategoria(dados) {
            document.getElementById('modal-titulo').innerText = "Editar Categoria";
            document.getElementById('cat-id').value = dados.id;
            document.getElementById('cat-nome').value = dados.nome;
            document.getElementById('cat-icone').value = dados.icone;
            document.getElementById('modal-cat').style.display = 'flex';
        }

        function fecharModal() {
            document.getElementById('modal-cat').style.display = 'none';
        }

        function salvarCategoria() {
            const payload = {
                id: document.getElementById('cat-id').value,
                nome: document.getElementById('cat-nome').value,
                icone: document.getElementById('cat-icone').value
            };

            if(!payload.nome) { alert("Nome é obrigatório!"); return; }

            fetch('../api/salvar_categoria_admin.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify(payload)
            })
            .then(res => res.json())
            .then(res => {
                if(res.sucesso) {
                    fecharModal();
                    carregarCategorias();
                } else {
                    alert("Erro: " + res.erro);
                }
            });
        }

        function excluirCategoria(id, nome) {
            if(!confirm(`Tem certeza que deseja excluir "${nome}"?`)) return;

            fetch('../api/excluir_categoria.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({id: id})
            })
            .then(res => res.json())
            .then(res => {
                if(res.sucesso) {
                    carregarCategorias();
                } else {
                    alert("Erro: " + res.erro);
                }
            });
        }
    </script>
</body>
</html>