<?php require 'config.php'; ?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>TV Player - Templates</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;900&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body, html { margin: 0; background: #050510; font-family: 'Montserrat', sans-serif; overflow: hidden; height: 100vh; width: 100vw; }
        
        /* LAYERS */
        #bgLayer { position: fixed; width: 100%; height: 100%; background-size: cover; background-position: center; transition: opacity 1s, transform 15s; transform: scale(1); z-index: 0; }
        .zoom-in { transform: scale(1.05) !important; }
        #videoLayer { position: fixed; width: 100%; height: 100%; object-fit: cover; z-index: 1; display: none; background: black; }

        /* CONTAINER DE TEXTO (A MÁGICA DOS TEMPLATES) */
        #infoContainer {
            position: absolute; width: 100%; height: 100%; top: 0; left: 0;
            pointer-events: none; z-index: 5;
            transition: all 0.5s; opacity: 0;
        }
        #infoContainer.show { opacity: 1; }

        /* ELEMENTOS DE TEXTO (GENÉRICOS) */
        h1 { margin: 0; font-weight: 900; text-transform: uppercase; line-height: 0.9; transition: 0.5s; }
        p { font-weight: 800; margin-top: 10px; transition: 0.5s; }

        /* --- TEMPLATE 1: PADRÃO (Bottom Left) --- */
        .tpl-padrao { display:flex; flex-direction:column; justify-content:flex-end; align-items:flex-start; padding: 50px; background: linear-gradient(to top, rgba(0,0,0,0.9), transparent); }
        .tpl-padrao h1 { font-size: 7vw; color: #ffcc00; text-shadow: 4px 4px 0 rgba(0,0,0,0.5); }
        .tpl-padrao p { font-size: 3.5vw; color: #fff; text-shadow: 2px 2px 5px rgba(0,0,0,0.8); }

        /* --- TEMPLATE 2: IMPACTO (Centro Gigante) --- */
        .tpl-impacto { display:flex; flex-direction:column; justify-content:center; align-items:center; background: rgba(0,0,0,0.4); }
        .tpl-impacto h1 { font-size: 12vw; color: #fff; text-shadow: 0 0 30px #ff00de; text-align:center; }
        .tpl-impacto p { font-size: 4vw; color: #000; background: #fff; padding: 10px 40px; transform: skew(-10deg); margin-top: 20px; box-shadow: 10px 10px 0 rgba(255,0,222,0.5); }

        /* --- TEMPLATE 3: LATERAL (Direita Neon) --- */
        .tpl-lateral { display:flex; flex-direction:column; justify-content:center; align-items:flex-end; padding-right: 80px; background: linear-gradient(to left, rgba(0,0,0,0.9) 30%, transparent); }
        .tpl-lateral h1 { font-size: 8vw; color: #00ffed; text-align:right; border-right: 15px solid #00ffed; padding-right: 30px; text-shadow: 0 0 20px rgba(0,255,237,0.5); }
        .tpl-lateral p { font-size: 3vw; color: #fff; text-align:right; margin-right: 45px; margin-top: 20px; font-weight: 400; }

        /* --- TEMPLATE 4: MANCHETE (Topo Notícia) --- */
        .tpl-manchete { display:flex; flex-direction:column; justify-content:flex-start; align-items:flex-start; padding-top: 80px; padding-left: 50px; }
        .tpl-manchete h1 { font-size: 6vw; background: #ff3f34; color: #fff; padding: 20px 50px; box-shadow: 10px 10px 0 #000; }
        .tpl-manchete p { font-size: 3vw; background: #fff; color: #000; padding: 15px 40px; margin-top: 0; box-shadow: 10px 10px 0 #000; max-width: 80%; }

        /* --- TEMPLATE 5: NEON (Cyberpunk) --- */
        .tpl-neon { display:flex; flex-direction:column; justify-content:flex-end; align-items:center; padding-bottom: 120px; }
        .tpl-neon h1 { font-size: 9vw; color: transparent; -webkit-text-stroke: 3px #00ff00; text-shadow: 0 0 30px #00ff00; letter-spacing: 5px; }
        .tpl-neon p { font-size: 3.5vw; color: #fff; text-shadow: 0 0 15px #00ff00; border-top: 4px solid #00ff00; border-bottom: 4px solid #00ff00; padding: 20px 60px; background: rgba(0,0,0,0.7); backdrop-filter: blur(5px); }

        /* RESTO (TICKER, RELÓGIO) */
        #tickerContainer { position: absolute; top: 0; left: 0; width: 100%; height: 12vh; background: #c0392b; z-index: 100; display: flex; align-items: center; justify-content: center; box-shadow: 0 5px 20px rgba(0,0,0,0.5); transform: translateY(-100%); transition: 0.5s; }
        #tickerContainer.ativo { transform: translateY(0); }
        #tickerText { font-size: 4vh; font-weight: 900; color: #fff; text-transform: uppercase; text-align: center; width: 90%; opacity: 0; transition: 0.5s; }
        #tickerText.visivel { opacity: 1; }
        
        #relogioBox { position: absolute; top: 40px; left: 40px; z-index: 20; transition: top 0.5s; text-shadow: 2px 2px 5px rgba(0,0,0,0.8); }
        .relogio-down { top: 15vh !important; }
        #hora { font-size: 5vw; font-weight: 900; color: #fff; line-height: 0.9; }
        #data { font-size: 1.8vw; font-weight: 700; color: #ddd; text-transform: uppercase; margin-left: 5px; }
        #logo { position: absolute; top: 40px; right: 40px; width: 12vw; z-index: 10; transition: top 0.5s; }
        .logo-down { top: 15vh !important; }
    </style>
</head>
<body>

    <div id="tickerContainer"><div id="tickerText">...</div></div>
    <video id="videoLayer" muted playsinline></video>
    <div id="bgLayer"></div>

    <div id="infoContainer" class="tpl-padrao">
        <h1 id="tit"></h1>
        <p id="txt"></p>
    </div>

    <div id="relogioBox"><div id="hora">00:00</div><div id="data">---</div></div>
    <img id="logo" src="uploads/logo_padrao.png" onerror="this.style.display='none'">
    
    <script>
        // ... (FUNÇÕES RELÓGIO E AVISOS IGUAIS AO ANTERIOR) ...
        function atualizarRelogio() { const agora = new Date(); document.getElementById('hora').innerText = String(agora.getHours()).padStart(2,'0') + ':' + String(agora.getMinutes()).padStart(2,'0'); document.getElementById('data').innerText = agora.toLocaleDateString('pt-BR', {weekday:'short', day:'numeric', month:'short'}); }
        setInterval(atualizarRelogio, 1000); atualizarRelogio();

        // TICKER SIMPLIFICADO
        function checarAvisos() {
            fetch('api_avisos.php').then(r=>r.json()).then(lista=>{
                const tk = document.getElementById('tickerContainer');
                if(lista && lista.length > 0) {
                    tk.classList.add('ativo'); document.getElementById('tickerText').innerText = lista[0].mensagem; document.getElementById('tickerText').classList.add('visivel'); tk.style.backgroundColor = lista[0].cor_fundo;
                    document.getElementById('relogioBox').classList.add('relogio-down'); document.getElementById('logo').classList.add('logo-down');
                } else {
                    tk.classList.remove('ativo'); document.getElementById('relogioBox').classList.remove('relogio-down'); document.getElementById('logo').classList.remove('logo-down');
                }
            });
        }
        setInterval(checarAvisos, 10000); checarAvisos();

        // --- PLAYER COM SUPORTE A TEMPLATES ---
        const formato = "<?= $_GET['formato'] ?? '16:9' ?>";
        let playlist = [], index = 0;

        async function loadPlaylist() { try { playlist = await (await fetch(`api_playlist.php?formato=${formato}`)).json(); } catch(e){} }
        
        function play() {
            if(!playlist.length) { loadPlaylist(); return setTimeout(play, 3000); }
            const item = playlist[index];
            
            const bg = document.getElementById('bgLayer');
            const vid = document.getElementById('videoLayer');
            const box = document.getElementById('infoContainer');

            // Reset
            box.classList.remove('show');
            bg.classList.remove('zoom-in');
            vid.style.display = 'none'; vid.pause();

            setTimeout(() => {
                // APLICA O TEMPLATE ESCOLHIDO
                box.className = ''; // Limpa classes antigas
                box.classList.add('tpl-' + (item.layout || 'padrao')); // Adiciona a nova (ex: tpl-impacto)

                if (item.tipo_conteudo === 'video') {
                    bg.style.display = 'none';
                    vid.src = item.imagem_url;
                    vid.style.display = 'block';
                    if(item.titulo) {
                        document.getElementById('tit').innerText = item.titulo;
                        box.classList.add('show');
                    }
                    vid.play();
                    vid.onended = () => proximo();
                } else {
                    bg.style.display = 'block';
                    bg.style.backgroundImage = `url('${item.imagem_url}')`;
                    document.getElementById('tit').innerText = item.titulo;
                    document.getElementById('txt').innerText = item.texto_conteudo;
                    
                    box.classList.add('show');
                    setTimeout(()=>bg.classList.add('zoom-in'), 100);
                    setTimeout(proximo, 15000);
                }
            }, 500);
        }

        function proximo() {
            index++; if(index >= playlist.length) { index = 0; loadPlaylist(); }
            play();
        }

        loadPlaylist().then(() => play());
    </script>
</body>
</html>