<?php
require 'config.php';
require 'ai_generator.php';

echo "<h1>Testando Conexão com IA...</h1>";

// 1. Testa permissão da pasta
if (!is_writable('uploads/')) {
    echo "<p style='color:red'>ERRO: A pasta 'uploads' não tem permissão de escrita. O PHP não consegue salvar a imagem.</p>";
} else {
    echo "<p style='color:green'>OK: Pasta uploads com permissão de escrita.</p>";
}

// 2. Testa Geração de Texto
echo "<h3>Tentando gerar texto...</h3>";
$texto = buscarTextoIA("Teste");
echo "<b>Resposta:</b> " . $texto . "<br>";

// 3. Testa Geração de Imagem
echo "<h3>Tentando gerar imagem...</h3>";
$imagem = gerarImagemIA("Teste");

if ($imagem) {
    echo "<p style='color:green'>Sucesso! Imagem salva em: $imagem</p>";
    echo "<img src='$imagem' width='200'>";
} else {
    echo "<p style='color:red'>Falha ao gerar imagem.</p>";
}
?>