<?php
// admin.php - VERSÃO FINAL: DELETE FUNCIONANDO (GALERIA E PLAYLIST)
date_default_timezone_set('America/Sao_Paulo');
ini_set('upload_max_filesize', '100M');
ini_set('post_max_size', '100M');
set_time_limit(300);

require 'config.php';
require 'ai_generator.php';

// --- 1. AJAX APAGAR ARQUIVO (ÚNICO OU EM MASSA) ---
if (isset($_POST['acao']) && $_POST['acao'] == 'apagar_arquivos_ajax') {
    header('Content-Type: application/json');
    $dados = json_decode($_POST['lista_arquivos']);
    // Garante que seja array mesmo se vier um só
    $arquivos = is_array($dados) ? $dados : [$dados]; 
    $removidos = 0;
    
    foreach ($arquivos as $arq) {
        // Segurança: previne apagar arquivos fora da pasta uploads
        $nome = basename($arq);
        $caminho = 'uploads/' . $nome;
        if (file_exists($caminho)) { unlink($caminho); $removidos++; }
    }
    echo json_encode(['sucesso' => true, 'qtd' => $removidos]); exit;
}

// --- 2. AJAX REORDENAR ---
if (isset($_POST['acao']) && $_POST['acao'] == 'reordenar') {
    $ordem = json_decode($_POST['lista_ids']);
    foreach ($ordem as $posicao => $id) {
        $pdo->prepare("UPDATE conteudos SET ordem = ? WHERE id = ?")->execute([$posicao, $id]);
    }
    exit;
}

// --- 3. AÇÕES GET (BANCO DE DADOS) ---
if (isset($_GET['del_conteudo'])) {
    $pdo->query("DELETE FROM conteudos WHERE id = " . (int)$_GET['del_conteudo']);
    header("Location: admin.php"); exit;
}
if (isset($_GET['del_aviso'])) {
    $pdo->query("DELETE FROM avisos WHERE id = " . (int)$_GET['del_aviso']);
    header("Location: admin.php"); exit;
}
if (isset($_GET['toggle_conteudo'])) {
    $pdo->query("UPDATE conteudos SET ativo = NOT ativo WHERE id = " . (int)$_GET['toggle_conteudo']);
    header("Location: admin.php"); exit;
}

// --- 4. SALVAR CONTEÚDO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] == 'salvar_conteudo') {
    $tipo = $_POST['tipo_conteudo'];
    $dados_grafico = null;
    $url_final = '';
    $layout = !empty($_POST['layout_escolhido']) ? $_POST['layout_escolhido'] : 'padrao';

    if (!empty($_FILES['arquivo_upload']['name'])) {
        $ext = strtolower(pathinfo($_FILES['arquivo_upload']['name'], PATHINFO_EXTENSION));
        $prefixo = ($tipo == 'video') ? 'vid_' : 'img_';
        $path = 'uploads/' . $prefixo . uniqid() . '.' . $ext;
        if (move_uploaded_file($_FILES['arquivo_upload']['tmp_name'], $path)) $url_final = $path;
    } elseif (!empty($_POST['media_existente'])) {
        $url_final = $_POST['media_existente'];
    } elseif (!empty($_POST['hidden_bg_url'])) {
        $url_final = $_POST['hidden_bg_url'];
    }

    if ($tipo === 'grafico') {
        $dados_grafico = json_encode([
            'labels' => explode(',', $_POST['grafico_labels']),
            'data' => explode(',', $_POST['grafico_dados']),
            'label' => $_POST['grafico_titulo']
        ]);
        $url_final = '';
    }

    $maxOrdem = $pdo->query("SELECT MAX(ordem) FROM conteudos")->fetchColumn();
    $stmt = $pdo->prepare("INSERT INTO conteudos (titulo, texto_conteudo, imagem_url, dados_grafico, tipo_conteudo, formato, ativo, ordem, layout) VALUES (?, ?, ?, ?, ?, ?, 1, ?, ?)");
    $stmt->execute([$_POST['titulo'], $_POST['texto'], $url_final, $dados_grafico, $tipo, $_POST['formato'], $maxOrdem + 1, $layout]);
}

// --- 5. SALVAR AVISO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] == 'salvar_aviso') {
    if (!empty($_POST['id_aviso'])) {
        $stmt = $pdo->prepare("UPDATE avisos SET mensagem=?, cor_fundo=?, data_inicio=?, data_fim=? WHERE id=?");
        $stmt->execute([$_POST['aviso_msg'], $_POST['aviso_cor'], $_POST['data_inicio'], $_POST['data_fim'], $_POST['id_aviso']]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO avisos (mensagem, cor_fundo, data_inicio, data_fim, ativo) VALUES (?, ?, ?, ?, 1)");
        $stmt->execute([$_POST['aviso_msg'], $_POST['aviso_cor'], $_POST['data_inicio'], $_POST['data_fim']]);
    }
    header("Location: admin.php"); exit;
}

// LEITURAS
$playlist = $pdo->query("SELECT * FROM conteudos ORDER BY ordem ASC")->fetchAll(PDO::FETCH_ASSOC);
$avisosAtivos = $pdo->query("SELECT * FROM avisos WHERE data_fim >= NOW() ORDER BY data_inicio ASC")->fetchAll(PDO::FETCH_ASSOC);
$avisosHistorico = $pdo->query("SELECT * FROM avisos WHERE data_fim < NOW() ORDER BY id DESC LIMIT 20")->fetchAll(PDO::FETCH_ASSOC);

// GALERIA SCAN
$arquivos = array_diff(scandir('uploads'), array('.', '..'));
$galeriaImagens = []; $galeriaVideos = [];
foreach($arquivos as $arq) {
    $ext = strtolower(pathinfo($arq, PATHINFO_EXTENSION)); $c = 'uploads/' . $arq;
    if(in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) $galeriaImagens[] = $c;
    elseif(in_array($ext, ['mp4', 'webm'])) $galeriaVideos[] = $c;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Gestor TV - Final</title>
    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.14.0/Sortable.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;900&display=swap" rel="stylesheet">
    
    <style>
        :root { --primary: #ffcc00; --dark: #0f1016; --gray: #1f2235; --text: #eee; }
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--dark); color: var(--text); display: flex; height: 100vh; overflow: hidden; }
        
        /* SIDEBAR */
        .sidebar { width: 340px; background: #050510; padding: 20px; border-right: 1px solid #222; overflow-y: auto; display: flex; flex-direction: column; gap: 15px; flex-shrink: 0; z-index: 20; }
        .main { flex: 1; padding: 20px; background: #12121a; overflow-y: auto; display: flex; flex-direction: column; align-items: center; }

        @media (max-width: 900px) {
            body { flex-direction: column; overflow-y: auto; }
            .sidebar { width: 100%; height: auto; max-height: 50vh; border-right: none; border-bottom: 2px solid var(--primary); order: 1; }
            .main { width: 100%; height: auto; order: 2; padding: 10px; }
        }

        /* PREVIEW BOX */
        .preview-wrapper { width: 100%; display: flex; justify-content: center; margin-bottom: 30px; flex-shrink: 0; }
        #previewBox { position: relative; background: #000; overflow: hidden; border: 4px solid #333; font-family: 'Montserrat', sans-serif; box-shadow: 0 10px 30px rgba(0,0,0,0.5); width: 100%; max-width: 720px; aspect-ratio: 16 / 9; }
        .fmt-9-16 { max-width: 350px !important; aspect-ratio: 9 / 16 !important; }
        #bgLayer { position: absolute; top:0; left: 0; width: 100%; height: 100%; background-size: contain !important; background-position: center center !important; background-repeat: no-repeat !important; z-index: 0; }
        
        /* TEMPLATE TEXT */
        .text-layer { position: absolute; top:0; left:0; width: 100%; height: 100%; padding: 30px; pointer-events: none; z-index: 2; display: flex; flex-direction: column; overflow-wrap: break-word; word-break: break-word; }
        .text-layer h1 { margin: 0; font-weight: 900; text-transform: uppercase; line-height: 1; max-width: 100%; }
        .text-layer p { font-weight: 800; margin-top: 10px; max-width: 100%; line-height: 1.2; }

        /* TEMPLATES */
        #previewBox.tpl-padrao .text-layer { justify-content: flex-end; align-items: flex-start; background: linear-gradient(to top, rgba(0,0,0,0.9), transparent); }
        #previewBox.tpl-padrao h1 { color: #ffcc00; font-size: 2.5rem; text-shadow: 3px 3px 0 rgba(0,0,0,0.5); }
        #previewBox.tpl-padrao p { color: #fff; font-size: 1.2rem; text-shadow: 2px 2px 5px black; }

        #previewBox.tpl-impacto .text-layer { justify-content: center; align-items: center; background: rgba(0,0,0,0.4); }
        #previewBox.tpl-impacto h1 { color: #fff; font-size: 4rem; text-shadow: 0 0 20px #ff00de; text-align: center; }
        #previewBox.tpl-impacto p { color: #000; background: #fff; font-size: 1.5rem; padding: 5px 20px; transform: skew(-10deg); display: inline-block; }

        #previewBox.tpl-lateral .text-layer { justify-content: center; align-items: flex-end; padding-right: 50px; background: linear-gradient(to left, rgba(0,0,0,0.8), transparent); text-align: right; }
        #previewBox.tpl-lateral h1 { color: #00ffed; font-size: 3rem; border-right: 8px solid #00ffed; padding-right: 15px; display: inline-block; }
        #previewBox.tpl-lateral p { color: #fff; font-size: 1.2rem; margin-right: 25px; }

        #previewBox.tpl-manchete .text-layer { justify-content: flex-start; align-items: flex-start; padding-top: 50px; }
        #previewBox.tpl-manchete h1 { background: #ff3f34; color: #fff; font-size: 2.5rem; padding: 10px 20px; box-shadow: 5px 5px 0 black; display: inline-block; }
        #previewBox.tpl-manchete p { background: #fff; color: #000; font-size: 1rem; padding: 10px 20px; box-shadow: 5px 5px 0 black; margin-top: 5px; display: inline-block; }

        #previewBox.tpl-neon .text-layer { justify-content: flex-end; align-items: center; padding-bottom: 60px; text-align: center; }
        #previewBox.tpl-neon h1 { color: transparent; -webkit-text-stroke: 2px #00ff00; font-size: 3.5rem; text-shadow: 0 0 20px #00ff00; }
        #previewBox.tpl-neon p { color: #fff; border-top: 2px solid #00ff00; border-bottom: 2px solid #00ff00; padding: 5px 30px; background: rgba(0,0,0,0.6); display: inline-block; }

        /* UI COMPONENTS */
        .logo-area { text-align: center; color: var(--primary); font-weight: bold; font-size: 1.5rem; margin-bottom: 20px; }
        .tabs { display: flex; gap: 5px; margin-bottom: 10px; }
        .tab-btn { flex: 1; padding: 10px; background: var(--gray); border: none; color: #aaa; cursor: pointer; border-radius: 4px; }
        .tab-btn.active { background: var(--primary); color: #000; font-weight: bold; }
        .form-section { display: none; }
        .form-section.active { display: block; animation: fadeIn 0.3s; }
        input, select, textarea { width: 100%; padding: 10px; background: #1a1c29; border: 1px solid #334; color: #fff; border-radius: 4px; margin-top: 5px; }
        label { display: block; margin-top: 10px; font-size: 0.8rem; color: #889; }
        .btn-action { width: 100%; padding: 12px; margin-top: 15px; border: none; border-radius: 4px; font-weight: bold; cursor: pointer; }
        .btn-save { background: #27ae60; color: white; }
        .btn-alert { background: #e74c3c; color: white; }
        .btn-gallery { background: #e67e22; color: white; padding: 8px; border:none; width: 100%; margin-top: 5px; cursor: pointer; }
        .btn-ia { background: #5a4fcf; color: white; border:none; padding: 10px; cursor:pointer; }
        .tpl-selector { display: grid; grid-template-columns: repeat(5, 1fr); gap: 5px; margin-bottom: 10px; }
        .tpl-opt { height: 35px; border: 1px solid #444; cursor: pointer; display: flex; align-items: center; justify-content: center; background: #222; }
        .tpl-opt.selected { border-color: var(--primary); background: #333; color: var(--primary); }
        .btn-png { background: #2980b9; color: white; width: 100%; margin-top: 20px; padding: 10px; border:none; cursor:pointer; }
        .quick-tags { display: flex; gap: 3px; flex-wrap: wrap; margin-top:5px; }
        .tag-btn { flex: 1; padding: 5px; border: none; font-size: 0.75rem; cursor: pointer; color:white; border-radius:3px; }
        .t-nutri { background: #27ae60; } .t-saude { background: #3498db; } .t-gym { background: #c0392b; } .t-aqua { background: #00a8ff; }

        /* PLAYLIST */
        .playlist-grid { display: flex; flex-wrap: wrap; gap: 15px; justify-content: center; padding-bottom: 50px; }
        .play-item { width: 220px; aspect-ratio: 16/9; background: #000; border-radius: 6px; position: relative; overflow: hidden; border: 2px solid #333; cursor: grab; flex-shrink: 0; }
        .play-item img, .play-item video { width: 100%; height: 100%; object-fit: cover; opacity: 0.7; }
        .item-info { position: absolute; bottom: 0; left: 0; width: 100%; background: rgba(0,0,0,0.85); padding: 5px; color: #fff; text-align: center; pointer-events: none; }
        .item-tit { color: var(--primary); font-weight: bold; font-size: 0.8rem; text-transform: uppercase; overflow: hidden; white-space: nowrap; text-overflow: ellipsis; }
        .play-actions { 
            position: absolute; top: 0; right: 0; width: 100%; height: 30px; 
            background: linear-gradient(to bottom, rgba(0,0,0,0.8), transparent);
            display:flex; justify-content: flex-end; padding: 5px; gap: 5px; z-index: 10;
        }
        .badge { background: #fff; color: #000; padding: 4px 8px; border-radius: 3px; font-size: 12px; cursor: pointer; text-decoration:none; }
        .badge:hover { background: var(--primary); }
        .badge-del { background: #c0392b; color: white; }

        /* GALERIA & MODAL */
        #modalGaleria { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.95); z-index: 2000; align-items: center; justify-content: center; }
        .modal-content { background: #1a1c29; width: 90%; height: 90%; border-radius: 10px; padding: 15px; display: flex; flex-direction: column; border: 1px solid #333; }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; border-bottom: 1px solid #333; padding-bottom: 10px; }
        .modal-body { flex: 1; overflow-y: auto; padding: 10px; }
        .gallery-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(130px, 1fr)); gap: 10px; overflow-y: auto; padding: 10px; }
        .gallery-item { position: relative; border: 2px solid #333; cursor: pointer; aspect-ratio: 16/9; background:#000; overflow: hidden; }
        .gallery-item img, .gallery-item video { width: 100%; height: 100%; object-fit: contain; }
        
        /* BOTÃO DELETE NA GALERIA (CORRIGIDO) */
        .btn-del-gal { 
            position: absolute; top: 0; right: 0; 
            background: #c0392b; color: white; border: none; 
            padding: 5px 8px; cursor: pointer; z-index: 20; 
            font-size: 12px; border-bottom-left-radius: 5px;
        }
        .check-overlay { position: absolute; top: 5px; left: 5px; width: 20px; height: 20px; border: 2px solid white; border-radius: 50%; background: rgba(0,0,0,0.5); z-index: 15; }
        .gallery-item.selected { border-color: #c0392b; } 
        .gallery-item.selected .check-overlay { background: #c0392b; border-color: #c0392b; }
        #btnApagarMassa { display: none; background: #c0392b; color: white; border: none; padding: 8px 15px; border-radius: 4px; font-weight: bold; cursor: pointer; }

        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
    </style>
</head>
<body>

<div class="sidebar">
    <div class="logo-area"><i class="fas fa-tv"></i> GESTOR TV</div>
    
    <div class="tabs">
        <button class="tab-btn active" onclick="switchTab('img')">Img</button>
        <button class="tab-btn" onclick="switchTab('video')">Vídeo</button>
        <button class="tab-btn" onclick="switchTab('chart')">Graf</button>
        <button class="tab-btn" onclick="switchTab('aviso')">Avisos</button>
    </div>

    <div id="formImg" class="form-section active">
        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="acao" value="salvar_conteudo"> <input type="hidden" name="tipo_conteudo" value="imagem">
            <select name="formato" id="selFormato" onchange="resizePreview()"><option value="16:9">Horizontal</option><option value="9:16">Vertical</option></select>
            
            <label>Estilo:</label>
            <div class="tpl-selector">
                <input type="hidden" name="layout_escolhido" id="inpLayout" value="padrao">
                <div class="tpl-opt selected" onclick="setTemplate('padrao')" title="Padrão"><i class="fas fa-image"></i></div>
                <div class="tpl-opt" onclick="setTemplate('impacto')" title="Impacto"><i class="fas fa-bomb"></i></div>
                <div class="tpl-opt" onclick="setTemplate('lateral')" title="Lateral"><i class="fas fa-columns"></i></div>
                <div class="tpl-opt" onclick="setTemplate('manchete')" title="Topo"><i class="fas fa-newspaper"></i></div>
                <div class="tpl-opt" onclick="setTemplate('neon')" title="Neon"><i class="fas fa-bolt"></i></div>
            </div>

            <div class="quick-tags">
                <button type="button" class="tag-btn t-gym" onclick="setTema('Musculação')">Treino</button>
                <button type="button" class="tag-btn t-aqua" onclick="setTema('Natação')">Natação</button>
                <button type="button" class="tag-btn t-aqua" onclick="setTema('Hidroginástica')">Hidro</button>
                <button type="button" class="tag-btn t-saude" onclick="setTema('Saúde')">Saúde</button>
                <button type="button" class="tag-btn t-nutri" onclick="setTema('Nutrição')">Nutri</button>
            </div>

            <div style="display:flex; gap:5px; margin-top:5px;">
                <input type="text" id="temaIA" placeholder="Tema IA"> <button type="button" class="btn-ia" onclick="gerarIA()">IA</button>
            </div>
            
            <label>Título</label><input type="text" name="titulo" id="inpTitulo" value="FOCO" onkeyup="updatePreview()">
            <label>Texto</label><textarea name="texto" id="inpTexto" rows="2" onkeyup="updatePreview()">Sem dor, sem ganho.</textarea>
            
            <button type="button" class="btn-gallery" onclick="abrirGaleria('img')">📂 Galeria</button>
            <div style="margin-top:5px; border-top:1px dashed #333; padding-top:5px;"><label style="margin:0; font-size:0.7rem;">Ou Upload:</label><input type="file" name="arquivo_upload" onchange="previewBg(this)"></div>
            <input type="hidden" name="hidden_bg_url" id="hiddenBgUrl"> <input type="hidden" name="media_existente" id="mediaExistenteImg">
            <button type="submit" class="btn-action btn-save">SALVAR</button>
        </form>
    </div>

    <div id="formVideo" class="form-section">
        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="acao" value="salvar_conteudo"> <input type="hidden" name="tipo_conteudo" value="video">
            <select name="formato"><option value="16:9">Horizontal</option><option value="9:16">Vertical</option></select>
            <label>Título</label><input type="text" name="titulo" placeholder="Ex: AULA">
            <button type="button" class="btn-gallery" onclick="abrirGaleria('video')">📂 Galeria</button>
            <div style="margin-top:5px; border-top:1px dashed #333; padding-top:5px;"><label style="margin:0; font-size:0.7rem;">Ou Upload:</label><input type="file" name="arquivo_upload" accept="video/mp4"></div>
            <input type="hidden" name="media_existente" id="mediaExistenteVid">
            <button type="submit" class="btn-action btn-save">SALVAR VÍDEO</button>
        </form>
    </div>

    <div id="formChart" class="form-section">
        <form method="POST">
            <input type="hidden" name="acao" value="salvar_conteudo"> <input type="hidden" name="tipo_conteudo" value="grafico"> <input type="hidden" name="formato" value="16:9">
            <input type="text" name="titulo" value="DADOS"> <input type="text" name="texto" value="Info">
            <input type="text" name="grafico_titulo" value="Legenda"> <input type="text" name="grafico_labels" value="A, B, C"> <input type="text" name="grafico_dados" value="10, 20, 30">
            <button type="submit" class="btn-action btn-save">SALVAR GRÁFICO</button>
        </form>
    </div>

    <div id="formAviso" class="form-section">
        <form method="POST" id="formAvisoTag">
            <input type="hidden" name="acao" value="salvar_aviso"> <input type="hidden" name="id_aviso" id="inpIdAviso">
            <label>Mensagem</label><input type="text" name="aviso_msg" id="inpAvisoMsg" required>
            <select name="aviso_cor" id="inpAvisoCor"><option value="#c0392b">🔴 Verm</option><option value="#2980b9">🔵 Azul</option><option value="#f39c12">🟠 Lar</option><option value="#27ae60">🟢 Verde</option></select>
            <label>Início/Fim</label><input type="datetime-local" name="data_inicio" id="inpAvisoInicio" value="<?= date('Y-m-d\TH:i') ?>"><input type="datetime-local" name="data_fim" id="inpAvisoFim" value="<?= date('Y-m-d\TH:i', strtotime('+1 day')) ?>">
            <button type="submit" class="btn-action btn-alert" id="btnSalvarAviso">AGENDAR</button>
            <button type="button" class="btn-action btn-alert" style="background:#777; display:none;" id="btnCancelarEdicao" onclick="limparEdicaoAviso()">CANCELAR</button>
        </form>
        
        <div style="margin-top:10px;">
            <strong style="color:#ffcc00; font-size:0.8rem;">NO AR:</strong>
            <?php foreach($avisosAtivos as $av): ?>
                <div style="border-left:3px solid <?= $av['cor_fundo'] ?>; background:#222; padding:5px; margin-bottom:5px; display:flex; justify-content:space-between;">
                    <span style="font-size:0.7rem;"><?= substr($av['mensagem'],0,20) ?>...</span>
                    <div><button style="border:none;background:none;color:orange;cursor:pointer;" onclick='editarAviso(<?= json_encode($av) ?>)'><i class="fas fa-pencil-alt"></i></button> <a href="?del_aviso=<?= $av['id'] ?>" style="color:red;"><i class="fas fa-times"></i></a></div>
                </div>
            <?php endforeach; ?>
            
            <strong style="color:#777; font-size:0.8rem; margin-top:15px; display:block;">HISTÓRICO:</strong>
            <?php foreach($avisosHistorico as $av): ?>
                <div style="border-left:3px solid #555; background:#191919; padding:5px; margin-bottom:5px; display:flex; justify-content:space-between; opacity:0.7;">
                    <span style="font-size:0.7rem;"><?= substr($av['mensagem'],0,20) ?>...</span>
                    <div>
                        <button style="border:none;background:none;color:#3498db;cursor:pointer;" onclick='editarAviso(<?= json_encode($av) ?>)'><i class="fas fa-redo"></i></button> 
                        <a href="?del_aviso=<?= $av['id'] ?>" onclick="return confirm('Apagar?')" style="color:#555;"><i class="fas fa-trash"></i></a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <button class="btn-png" onclick="baixarPNG()"><i class="fas fa-download"></i> PNG</button>
</div>

<div class="main">
    <div class="preview-wrapper">
        <div id="previewBox" class="fmt-16-9 tpl-padrao">
            <div id="bgLayer"></div>
            <div class="text-layer" id="textLayer">
                <h1 id="prevTitulo">FOCO</h1><p id="prevTexto">Sem dor, sem ganho.</p>
            </div>
        </div>
    </div>

    <h2 style="color: #ffcc00; margin-top:10px; border-bottom: 2px solid #333; width:100%; font-size:1rem;"><i class="fas fa-layer-group"></i> Playlist</h2>
    <div class="playlist-container">
        <div id="listaPlaylist" class="playlist-grid">
            <?php foreach($playlist as $item): ?>
                <div class="play-item <?= $item['ativo']?'active':'' ?>" data-id="<?= $item['id'] ?>">
                    <?php if($item['tipo_conteudo']=='video'): ?><video src="<?= $item['imagem_url'] ?>" muted></video>
                    <?php elseif($item['tipo_conteudo']=='grafico'): ?><div style="width:100%;height:100%;background:#333;color:#ffcc00;display:flex;align-items:center;justify-content:center"><i class="fas fa-chart-bar fa-2x"></i></div>
                    <?php else: ?><img src="<?= $item['imagem_url'] ?>"><?php endif; ?>
                    
                    <div class="play-actions">
                        <a href="?toggle_conteudo=<?= $item['id'] ?>" class="badge"><i class="fas fa-power-off"></i></a>
                        <a href="?del_conteudo=<?= $item['id'] ?>" onclick="return confirm('Apagar?')" class="badge badge-del"><i class="fas fa-trash"></i></a>
                    </div>
                    
                    <div class="item-info">
                        <div class="item-tit"><?= substr($item['titulo'],0,15) ?></div>
                        <div class="item-desc"><?= substr($item['texto_conteudo'],0,20) ?>...</div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<div id="modalGaleria">
    <div class="modal-content">
        <div class="modal-header">
            <h3 style="color:#ffcc00; margin:0;">Galeria</h3>
            <div style="display:flex; gap:10px;">
                <button id="btnApagarMassa" onclick="apagarSelecionados()"><i class="fas fa-trash"></i> Apagar</button>
                <button onclick="fecharGaleria()" style="background:none; border:none; color:white; font-size:1.5rem; cursor:pointer;">&times;</button>
            </div>
        </div>
        <div style="display:flex; gap:5px; margin-bottom:10px;">
            <button class="tab-btn active" id="btnTabImg" onclick="filtroGaleria('img')">Imagens</button>
            <button class="tab-btn" id="btnTabVid" onclick="filtroGaleria('vid')">Vídeos</button>
        </div>
        <div class="modal-body">
            <div id="galeria-img" class="gallery-grid">
                <?php foreach($galeriaImagens as $img): ?>
                    <div class="gallery-item" onclick="selecionarItem(this, '<?= $img ?>', 'img')">
                        <img src="<?= $img ?>" loading="lazy">
                        <button class="btn-del-gal" onclick="event.stopPropagation(); deletarUnico('<?= $img ?>')"><i class="fas fa-trash"></i></button>
                        <div class="check-overlay" onclick="event.stopPropagation(); toggleSelecao(this, '<?= $img ?>')"></div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div id="galeria-vid" class="gallery-grid" style="display:none;">
                <?php foreach($galeriaVideos as $vid): ?>
                    <div class="gallery-item" onclick="selecionarItem(this, '<?= $vid ?>', 'vid')">
                        <video src="<?= $vid ?>" muted></video>
                        <button class="btn-del-gal" onclick="event.stopPropagation(); deletarUnico('<?= $vid ?>')"><i class="fas fa-trash"></i></button>
                        <div class="check-overlay" onclick="event.stopPropagation(); toggleSelecao(this, '<?= $vid ?>')"></div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<script>
    function setTemplate(nome) {
        document.getElementById('inpLayout').value = nome;
        document.querySelectorAll('.tpl-opt').forEach(b => b.classList.remove('selected'));
        event.currentTarget.classList.add('selected');
        const box = document.getElementById('previewBox');
        box.classList.forEach(c => { if(c.startsWith('tpl-')) box.classList.remove(c); });
        box.classList.add('tpl-' + nome);
    }

    function switchTab(mode) {
        document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active')); document.querySelectorAll('.form-section').forEach(f => f.classList.remove('active'));
        if(mode === 'aviso') { document.querySelectorAll('.tab-btn')[3].classList.add('active'); document.getElementById('formAviso').classList.add('active'); }
        else if (mode === 'img') { document.querySelectorAll('.tab-btn')[0].classList.add('active'); document.getElementById('formImg').classList.add('active'); }
        else if (mode === 'video') { document.querySelectorAll('.tab-btn')[1].classList.add('active'); document.getElementById('formVideo').classList.add('active'); }
        else { document.querySelectorAll('.tab-btn')[2].classList.add('active'); document.getElementById('formChart').classList.add('active'); }
    }
    
    function setTema(tema) { document.getElementById('temaIA').value = tema; gerarIA(); }
    function gerarIA() {
        const btn = document.querySelector('.btn-ia'); const iconOriginal = btn.innerHTML; btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>'; 
        const tema = document.getElementById('temaIA').value; const formato = document.getElementById('selFormato').value;
        const formData = new FormData(); formData.append('gerar_ia', 'true'); formData.append('tema', tema); formData.append('formato', formato);
        fetch('ajax_ia.php', { method: 'POST', body: formData }).then(r => r.json()).then(data => {
            if(data.erro) { alert(data.msg); } else { document.getElementById('inpTitulo').value = data.titulo; document.getElementById('inpTexto').value = data.texto; document.getElementById('hiddenBgUrl').value = data.imagem; document.getElementById('bgLayer').style.backgroundImage = `url('${data.imagem}')`; updatePreview(); }
        }).catch(err => alert("Erro rede")).finally(() => btn.innerHTML = iconOriginal);
    }

    function resizePreview() { const fmt = document.getElementById('selFormato').value; document.getElementById('previewBox').className = (fmt === '16:9') ? 'fmt-16-9' : 'fmt-9-16'; setTemplate(document.getElementById('inpLayout').value); }
    function updatePreview() { document.getElementById('prevTitulo').innerText = document.getElementById('inpTitulo').value; document.getElementById('prevTexto').innerText = document.getElementById('inpTexto').value; }
    function previewBg(input) { let r = new FileReader(); r.onload = (e) => { document.getElementById('bgLayer').style.backgroundImage = `url('${e.target.result}')`; }; if(input.files[0]) r.readAsDataURL(input.files[0]); }
    function baixarPNG() { html2canvas(document.getElementById('previewBox'), { useCORS: true, scale: 2 }).then(c => { let l = document.createElement('a'); l.download = 'arte.png'; l.href = c.toDataURL(); l.click(); }); }

    function editarAviso(aviso) {
        document.getElementById('inpIdAviso').value = aviso.id; document.getElementById('inpAvisoMsg').value = aviso.mensagem; document.getElementById('inpAvisoCor').value = aviso.cor_fundo;
        document.getElementById('inpAvisoInicio').value = aviso.data_inicio.replace(' ', 'T'); document.getElementById('inpAvisoFim').value = aviso.data_fim.replace(' ', 'T');
        document.getElementById('btnSalvarAviso').innerText = "SALVAR"; document.getElementById('btnSalvarAviso').style.background = "#f39c12"; document.getElementById('btnCancelarEdicao').style.display = "block";
    }
    function limparEdicaoAviso() {
        document.getElementById('formAvisoTag').reset(); document.getElementById('inpIdAviso').value = "";
        document.getElementById('btnSalvarAviso').innerText = "AGENDAR"; document.getElementById('btnSalvarAviso').style.background = "#e74c3c"; document.getElementById('btnCancelarEdicao').style.display = "none";
    }

    let tipoAtualGaleria = 'img';
    function abrirGaleria(tipo) { tipoAtualGaleria = tipo; document.getElementById('modalGaleria').style.display = 'flex'; filtroGaleria(tipo); }
    function fecharGaleria() { document.getElementById('modalGaleria').style.display = 'none'; }
    function filtroGaleria(tipo) {
        if(tipo === 'img') { document.getElementById('galeria-img').style.display = 'grid'; document.getElementById('galeria-vid').style.display = 'none'; document.getElementById('btnTabImg').classList.add('active'); document.getElementById('btnTabVid').classList.remove('active'); } 
        else { document.getElementById('galeria-img').style.display = 'none'; document.getElementById('galeria-vid').style.display = 'grid'; document.getElementById('btnTabImg').classList.remove('active'); document.getElementById('btnTabVid').classList.add('active'); }
    }
    function selecionarItem(elemento, url, tipo) {
        if (tipoAtualGaleria === 'img') { document.getElementById('hiddenBgUrl').value = url; document.getElementById('mediaExistenteImg').value = url; document.getElementById('bgLayer').style.backgroundImage = `url('${url}')`; } 
        else { document.getElementById('mediaExistenteVid').value = url; }
        fecharGaleria();
    }

    // --- DELETAR NA GALERIA (AJAX) ---
    function deletarUnico(url) {
        if(!confirm('Apagar permanentemente este arquivo?')) return;
        enviarDelete([url]);
    }
    
    let selecionadosParaApagar = [];
    function toggleSelecao(bolinha, url) {
        let item = bolinha.parentElement;
        if (selecionadosParaApagar.includes(url)) { selecionadosParaApagar = selecionadosParaApagar.filter(u => u !== url); item.classList.remove('selected'); bolinha.style.background = 'rgba(0,0,0,0.5)'; } 
        else { selecionadosParaApagar.push(url); item.classList.add('selected'); bolinha.style.background = '#c0392b'; }
        let btn = document.getElementById('btnApagarMassa');
        btn.style.display = selecionadosParaApagar.length > 0 ? 'block' : 'none';
        btn.innerHTML = `<i class="fas fa-trash"></i> (${selecionadosParaApagar.length})`;
    }
    function apagarSelecionados() {
        if (!confirm(`Apagar ${selecionadosParaApagar.length} arquivos?`)) return;
        enviarDelete(selecionadosParaApagar);
    }
    function enviarDelete(lista) {
        let formData = new FormData(); formData.append('acao', 'apagar_arquivos_ajax'); formData.append('lista_arquivos', JSON.stringify(lista));
        fetch('admin.php', { method: 'POST', body: formData }).then(r => r.json()).then(data => {
            if (data.sucesso) { location.reload(); }
        });
    }

    var el = document.getElementById('listaPlaylist');
    Sortable.create(el, { animation: 150, ghostClass: 'active', delay: 400, delayOnTouchOnly: true, onEnd: function (evt) { 
        var novaOrdem = []; document.querySelectorAll('.play-item').forEach(function(item){ novaOrdem.push(item.getAttribute('data-id')); }); 
        var formData = new FormData(); formData.append('acao', 'reordenar'); formData.append('lista_ids', JSON.stringify(novaOrdem)); fetch('admin.php', { method: 'POST', body: formData });
    }});
</script>
</body>
</html>