<?php
// ARQUIVO: gerar_pdf.php

require_once 'dompdf/autoload.inc.php'; 

use Dompdf\Dompdf;
use Dompdf\Options;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') die("Acesso inválido.");

// --- FUNÇÃO DE LIMPEZA ---
function limparDinheiroPHP($valor) {
    if (is_numeric($valor)) return floatval($valor);
    $valor = preg_replace('/[^\d,.]/', '', $valor);
    $valor = str_replace(',', '.', $valor);
    if(substr_count($valor, '.') > 1){
       $valor = str_replace('.', '', substr($valor, 0, strrpos($valor, '.'))) . substr($valor, strrpos($valor, '.'));
    }
    return floatval($valor);
}

// --- DADOS ---
$cliente_nome = $_POST['cliente_nome'] ?? 'Cliente';
$data_orcamento = $_POST['data_orcamento'] ?? date('d/m/Y');

$itens_nome = $_POST['item_nome'] ?? [];
$itens_unidade = $_POST['item_unidade'] ?? [];
$itens_qtd = $_POST['item_qtd'] ?? [];
$itens_valor = $_POST['item_valor'] ?? [];
$itens_total = $_POST['item_total'] ?? [];

// TOTAIS
$subtotal = limparDinheiroPHP($_POST['subtotal_post'] ?? 0);
$frete = limparDinheiroPHP($_POST['frete_post'] ?? 0);
$total_final = limparDinheiroPHP($_POST['total_final_post'] ?? 0);
$desc_valor = limparDinheiroPHP($_POST['desconto_valor_post'] ?? 0);
$desc_tipo = $_POST['desconto_tipo_post'] ?? 'valor';

// Cálculo do desconto real para exibição
$val_desc_real = ($desc_tipo == 'porcento') ? $subtotal * ($desc_valor/100) : $desc_valor;
$texto_desc = "";
if($val_desc_real > 0) {
    $texto_desc = ($desc_tipo == 'porcento') 
        ? "- R$ " . number_format($val_desc_real, 2, ',', '.') . " ({$desc_valor}%)"
        : "- R$ " . number_format($val_desc_real, 2, ',', '.');
}

// --- HTML DO PDF (DESIGN MODERNO) ---
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        @page { margin: 40px; }
        body { font-family: "Helvetica", sans-serif; font-size: 12px; color: #444; line-height: 1.4; }
        
        /* CABEÇALHO */
        .header { text-align: center; margin-bottom: 40px; }
        .logo { height: 80px; width: auto; margin-bottom: 10px; }
        .titulo-doc { font-size: 14px; letter-spacing: 2px; text-transform: uppercase; color: #999; margin-top: 5px; }

        /* INFO DO CLIENTE */
        .info-container { 
            width: 100%; 
            margin-bottom: 30px; 
            padding: 20px;
            background-color: #f8f9fa; /* Cinza bem clarinho */
            border-left: 5px solid #c00d0d; /* Vermelho da marca */
        }
        .info-label { font-size: 10px; text-transform: uppercase; color: #888; font-weight: bold; margin-bottom: 3px; }
        .info-valor { font-size: 14px; font-weight: bold; color: #222; margin-bottom: 0; }
        
        /* TABELA DE ITENS */
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        
        th { 
            background-color: #c00d0d; /* Cabeçalho Vermelho */
            color: white; 
            text-transform: uppercase; 
            font-size: 11px; 
            padding: 12px 10px; 
            text-align: left;
            font-weight: bold;
        }
        
        td { 
            padding: 12px 10px; 
            border-bottom: 1px solid #eee; 
            color: #333;
        }
        
        /* Zebrado sutil na tabela */
        tr:nth-child(even) { background-color: #fcfcfc; }

        /* Alinhamentos */
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .col-produto { width: 50%; }
        .col-qtd { width: 15%; }
        .col-unit { width: 15%; }
        .col-total { width: 20%; font-weight: bold; }

        /* TOTAIS */
        .box-totais { 
            width: 100%;
            page-break-inside: avoid;
        }
        .tabela-totais { 
            width: 40%; 
            float: right; 
            border-collapse: collapse; 
        }
        .tabela-totais td { 
            padding: 6px 0; 
            text-align: right; 
            border: none;
        }
        .label-resumo { color: #777; font-size: 12px; }
        .valor-resumo { font-size: 12px; font-weight: bold; color: #333; }
        
        .total-final-row td {
            padding-top: 15px;
            border-top: 2px solid #c00d0d;
        }
        .total-grande {
            font-size: 18px;
            font-weight: bold;
            color: #c00d0d;
        }

        /* RODAPÉ */
        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 9px;
            color: #aaa;
            border-top: 1px solid #eee;
            padding-top: 15px;
        }
    </style>
</head>
<body>

    <div class="header">
        <img src="https://mgatv.com.br/orca/logomais.webp" class="logo">
        <div class="titulo-doc">Orçamento Comercial</div>
    </div>

    <table style="width: 100%; margin-bottom: 30px;">
        <tr>
            <td style="padding: 0; border: none;">
                <div class="info-container">
                    <div class="info-label">Cliente / Evento</div>
                    <div class="info-valor">'.mb_strtoupper($cliente_nome).'</div>
                </div>
            </td>
            <td style="width: 20px; padding: 0; border: none;"></td> <td style="width: 150px; padding: 0; border: none; vertical-align: top;">
                <div class="info-container" style="border-left: 5px solid #444;">
                    <div class="info-label">Data de Emissão</div>
                    <div class="info-valor">'.$data_orcamento.'</div>
                </div>
            </td>
        </tr>
    </table>

    <table>
        <thead>
            <tr>
                <th class="col-produto">Descrição do Produto</th>
                <th class="col-qtd text-center">Qtd</th>
                <th class="col-unit text-right">Unitário</th>
                <th class="col-total text-right">Total</th>
            </tr>
        </thead>
        <tbody>';

        if(count($itens_nome) > 0) {
            for($i=0; $i<count($itens_nome); $i++){
                $v_unit = limparDinheiroPHP($itens_valor[$i]);
                $v_total = limparDinheiroPHP($itens_total[$i]);
                $un = trim($itens_unidade[$i]);
                
                // Formatação visual da quantidade com unidade pequena
                $qtd_display = $itens_qtd[$i];
                if($un) $qtd_display .= ' <span style="font-size:9px; color:#888;">' . $un . '</span>';

                $html .= '<tr>
                    <td>'.$itens_nome[$i].'</td>
                    <td class="text-center">'.$qtd_display.'</td>
                    <td class="text-right">R$ '.number_format($v_unit, 2, ',', '.').'</td>
                    <td class="text-right">R$ '.number_format($v_total, 2, ',', '.').'</td>
                </tr>';
            }
        } else {
            $html .= '<tr><td colspan="4" class="text-center" style="padding: 30px; color: #ccc;">Nenhum item adicionado.</td></tr>';
        }

$html .= '
        </tbody>
    </table>

    <div class="box-totais">
        <table class="tabela-totais">
            <tr>
                <td class="label-resumo">Subtotal de Itens:</td>
                <td class="valor-resumo">R$ '.number_format($subtotal, 2, ',', '.').'</td>
            </tr>';
            
            if($frete > 0) {
                $html .= '<tr>
                    <td class="label-resumo">Frete / Entrega:</td>
                    <td class="valor-resumo">+ R$ '.number_format($frete, 2, ',', '.').'</td>
                </tr>';
            }
            
            if($val_desc_real > 0) {
                $html .= '<tr>
                    <td class="label-resumo" style="color: #d32f2f;">Desconto Aplicado:</td>
                    <td class="valor-resumo" style="color: #d32f2f;">'.$texto_desc.'</td>
                </tr>';
            }

$html .= '
            <tr class="total-final-row">
                <td style="font-size: 14px; font-weight:bold; color:#333;">TOTAL A PAGAR:</td>
                <td class="total-grande">R$ '.number_format($total_final, 2, ',', '.').'</td>
            </tr>
        </table>
        <div style="clear: both;"></div>
    </div>

    <div class="footer">
        Este documento é um orçamento simples para conferência e não possui valor fiscal.<br>
        Obrigado pela preferência!
    </div>

</body>
</html>';

// --- GERAÇÃO ---
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// --- SALVAR ---
$nome_limpo = preg_replace('/[^a-zA-Z0-9]/', '_', $cliente_nome);
$nome_arquivo = "Orcamento_" . $nome_limpo . "_" . date('Y-m-d_His') . ".pdf";

if(!is_dir('orcamentos_pdfs')) mkdir('orcamentos_pdfs');
file_put_contents("orcamentos_pdfs/" . $nome_arquivo, $dompdf->output());

// --- EXIBIR ---
$dompdf->stream($nome_arquivo, ["Attachment" => false]);
?>