<?php
// ARQUIVO: ai_generator.php
// ATUALIZAÇÃO: Busca focada em Treino Pesado vs Nutrição

function traduzirTermoFitness($termoOriginal) {
    $termo = strtolower(trim($termoOriginal));
    
    // 1. DICIONÁRIO MANUAL (Termos Específicos)
    $dicionario = [
        // TREINO / ACADEMIA (Prioridade Máxima)
        'musculacao' => 'bodybuilding gym workout weights',
        'treino' => 'gym workout fitness athlete',
        'crossfit' => 'crossfit intense workout',
        'aerobico' => 'cardio treadmill running gym',
        'esteira' => 'treadmill running gym',
        'yoga' => 'yoga pose fitness',
        'pilates' => 'pilates reformer gym',
        'perna' => 'leg day workout gym',
        'braco' => 'biceps workout gym',
        'costas' => 'back workout bodybuilding',
        'gluteo' => 'squat woman gym fitness',
        'abdominal' => 'abs workout core fitness',
        'funcional' => 'functional training gym',
        'boxe' => 'boxing training gym',
        'luta' => 'mma fighting gym',
        'zumba' => 'zumba dance fitness class',
        'spinning' => 'spinning bike gym class',

        // NUTRIÇÃO (Comida)
        'nutricao' => 'fresh healthy food vegetables fruits',
        'dieta' => 'healthy meal prep chicken salad',
        'fruta' => 'fresh fruits close up',
        'salada' => 'healthy salad bowl',
        'proteina' => 'grilled chicken steak food',
        'agua' => 'drinking water bottle gym',
        'suplemento' => 'whey protein shake powder',
        'detox' => 'green detox juice',

        // SAÚDE (Bem-estar)
        'saude' => 'doctor medical checkup',
        'bem-estar' => 'meditation relaxing yoga',
        'sono' => 'sleeping bed peaceful',
        'coracao' => 'heart rate monitor smart watch',
        'fisioterapia' => 'physiotherapy massage'
    ];

    // Verifica se a palavra exata existe no dicionário
    foreach ($dicionario as $pt => $en) {
        if (strpos($termo, $pt) !== false) return $en;
    }

    // 2. LÓGICA DE FALLBACK (Se não achou no dicionário)
    
    // Se parecer nutrição...
    if (strpos($termo, 'comer') !== false || strpos($termo, 'alimento') !== false) {
        return $termoOriginal . " healthy food";
    }

    // Se parecer saúde...
    if (strpos($termo, 'medico') !== false || strpos($termo, 'dor') !== false) {
        return "doctor health medicine";
    }

    // *** O PULO DO GATO ***
    // Se não for comida nem médico, ASSUME QUE É TREINO!
    // Adiciona termos agressivos de academia para garantir fotos de exercício
    return $termoOriginal . " gym workout fitness athlete intense";
}

function buscarTextoIA($tema) {
    $termo = strtolower($tema);

    // Dicas de Nutrição
    $dicasNutri = [
        ['titulo' => 'HIDRATE-SE', 'texto' => 'Músculo desidratado não cresce. Beba água durante o treino.'],
        ['titulo' => 'COMER LIMPO', 'texto' => 'Descasque mais, desembale menos. Prefira alimentos naturais.'],
        ['titulo' => 'PRÉ-TREINO', 'texto' => 'Carboidratos complexos 1h antes do treino garantem energia.'],
        ['titulo' => 'PÓS-TREINO', 'texto' => 'Proteína é essencial agora para recuperar as fibras musculares.'],
        ['titulo' => 'FRUTAS', 'texto' => 'A melhor sobremesa é uma fruta. Rica em fibras e vitaminas.']
    ];

    // Dicas de Saúde
    $dicasSaude = [
        ['titulo' => 'SONO', 'texto' => 'É dormindo que o músculo cresce. Garanta 8h de sono.'],
        ['titulo' => 'POSTURA', 'texto' => 'Coluna ereta evita lesões. Concentre-se no movimento.'],
        ['titulo' => 'CHECK-UP', 'texto' => 'Faça exames regularmente. Prevenção é o melhor remédio.'],
        ['titulo' => 'MENTE SÃ', 'texto' => 'Treinar combate a ansiedade e libera endorfina.']
    ];

    // Dicas de Treino (Padrão)
    $dicasTreino = [
        ['titulo' => 'FOCO TOTAL', 'texto' => 'Esqueça o celular. Conecte-se com seu músculo.'],
        ['titulo' => 'CONSTÂNCIA', 'texto' => 'O segredo não é a intensidade, é a frequência.'],
        ['titulo' => 'SEM DESCULPAS', 'texto' => 'Seu corpo aguenta quase tudo. É sua mente que você precisa convencer.'],
        ['titulo' => 'FALHA', 'texto' => 'Vá até a falha. É lá que o resultado mora.'],
        ['titulo' => 'PESO LIVRE', 'texto' => 'Priorize exercícios compostos para máxima força.']
    ];

    // Seleção Inteligente
    if (strpos($termo, 'nutri') !== false || strpos($termo, 'dieta') !== false || strpos($termo, 'fruta') !== false) {
        return $dicasNutri[array_rand($dicasNutri)];
    }
    
    if (strpos($termo, 'saude') !== false || strpos($termo, 'sono') !== false || strpos($termo, 'bem') !== false) {
        return $dicasSaude[array_rand($dicasSaude)];
    }

    return $dicasTreino[array_rand($dicasTreino)];
}

function gerarImagemIA($tema, $formato = '16:9') {
    if (!defined('API_KEY_PEXELS') || empty(API_KEY_PEXELS)) {
        return 'https://placehold.co/1920x1080/000/FFF?text=ERRO+API';
    }
    if (!is_dir('uploads')) mkdir('uploads', 0777, true);

    $orientacao = ($formato == '9:16') ? 'portrait' : 'landscape';
    
    // AQUI ESTÁ A MÁGICA: Usa a nova função de tradução
    $termoBusca = urlencode(traduzirTermoFitness($tema));
    
    $pagina = rand(1, 10); 

    $url = "https://api.pexels.com/v1/search?query=$termoBusca&orientation=$orientacao&size=large&per_page=1&page=$pagina";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: ' . API_KEY_PEXELS]);

    $result = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($result, true);

    // Baixa em FULL HD ('large') para não travar o zoom
    if (isset($json['photos'][0]['src']['large'])) {
        $urlRemota = $json['photos'][0]['src']['large']; 
        $conteudo = file_get_contents($urlRemota);
        if ($conteudo) {
            $nomeArquivo = 'uploads/pexels_' . uniqid() . '.jpg';
            file_put_contents($nomeArquivo, $conteudo);
            return $nomeArquivo;
        }
    }

    // Se falhar na página aleatória, tenta a página 1 (Garantia)
    if ($pagina > 1) {
        $url = "https://api.pexels.com/v1/search?query=$termoBusca&orientation=$orientacao&size=large&per_page=1&page=1";
        // ... (repetiria o curl aqui, mas para simplificar, se falhar retorna placeholder)
    }

    return 'https://placehold.co/1920x1080/333/FFF?text=TENTE+OUTRO+TERMO';
}
?>